/* Copy memory area and return pointer after last written byte.
   Copyright 2024,2026 Thomas E. Dickey
   Copyright (C) 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  */

#if HAVE_MEMPCPY

#  include <string.h>

#else

#  include <sys/types.h>
/* Copy N bytes of SRC to DEST, return pointer to bytes after the
   last written byte.  */
#define mempcpy(d,s,n) replace_mempcpy(d,s,n)
extern void *mempcpy (void *dest, const void *src, size_t n);

#endif
